<?php
declare(strict_types=1);
require __DIR__ . '/db.php';
require_installed();
require_admin();

$data = read_json_body();
$bookId = (int)($data['book_id'] ?? 0);
if ($bookId <= 0) json_response(['ok' => false, 'error' => 'book_id fehlt.'], 400);

try {
  $pdo = db();
  $upd = $pdo->prepare("UPDATE loans SET returned_at = date('now') WHERE book_id = ? AND returned_at IS NULL");
  $upd->execute([$bookId]);

  if ($upd->rowCount() === 0) {
    json_response(['ok' => false, 'error' => 'Keine aktive Ausleihe gefunden.'], 404);
  }
  json_response(['ok' => true, 'message' => 'Rückgabe-Datum gesetzt.']);
} catch (Throwable $e) {
  json_response(['ok' => false, 'error' => $e->getMessage()], 500);
}
